/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.expressionbuilder;

import filenet.vw.api.VWException;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDialogButtons;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWDialogButtonsActionListener;
import filenet.vw.toolkit.utils.event.VWDialogButtonsActionEvent;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWArrayEditor;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionEditor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class VWExpressionArrayBuilderDialog
extends VWModalDialog
implements IVWDialogButtonsActionListener {
    private VWArrayEditor m_arrayEditor = null;
    private VWDialogButtons m_dialogButtons = null;
    private GridBagConstraints m_gbCons = null;
    private IVWPropertyData m_propertyData = null;
    private int m_result = 1;
    private String m_currentValue = new String("{}");
    private String m_name = null;
    private int m_type = -1;

    public VWExpressionArrayBuilderDialog(Frame parent, IVWPropertyData propertyData, String currentValue, String name, int type) {
        super(parent);
        this.m_propertyData = propertyData;
        this.m_currentValue = currentValue;
        this.m_name = name;
        this.m_type = type;
    }

    public VWExpressionArrayBuilderDialog(Dialog parent, IVWPropertyData propertyData, String currentValue, String name, int type) {
        super(parent);
        this.m_propertyData = propertyData;
        this.m_currentValue = currentValue;
        this.m_name = name;
        this.m_type = type;
    }

    public void init() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.setTitle(VWResource.s_expressionArrayBuilderStr);
        Dimension dim = VWStringUtils.stringToDimension("685,445");
        if (dim != null) {
            this.setSize(dim);
        } else {
            this.setSize(new Dimension(600, 400));
        }
        this.initControls();
        this.initDialogControls();
        this.m_arrayEditor.setCurrentExpressionItem(this.m_currentValue);
    }

    public int getDialogResult() {
        return this.m_result;
    }

    public String getExpressionString() {
        return this.m_currentValue;
    }

    public void dialogButtonsActionPerformed(VWDialogButtonsActionEvent event) {
        switch (event.getID()) {
            case 1: {
                this.performOK();
                break;
            }
            case 2: {
                this.performCancel();
                break;
            }
            case 32: {
                this.performHelp();
            }
        }
    }

    private void initControls() {
        ++this.m_gbCons.gridy;
        this.m_gbCons.fill = 1;
        this.m_gbCons.weighty = 1.0;
        this.m_gbCons.insets = new Insets(5, 5, 0, 5);
        this.m_arrayEditor = new VWArrayEditor(new VWExpressionEditor(this.m_parent), this.m_propertyData, this.m_name, this.m_type);
        this.m_arrayEditor.init();
        this.getContentPane().add((Component)this.m_arrayEditor, this.m_gbCons);
    }

    private void initDialogControls() {
        this.m_gbCons.anchor = 10;
        this.m_gbCons.fill = 0;
        this.m_gbCons.gridx = 0;
        ++this.m_gbCons.gridy;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(5, 5, 5, 5);
        this.m_dialogButtons = new VWDialogButtons(35);
        this.m_dialogButtons.addDialogButtonsActionListener(this);
        this.getContentPane().add((Component)this.m_dialogButtons, this.m_gbCons);
    }

    private void performOK() {
        try {
            this.m_currentValue = this.m_arrayEditor.getCurrentExpressionItem();
            this.m_result = 0;
            this.setVisible(false);
        }
        catch (VWException ex) {
            VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), 1);
        }
    }

    private void performCancel() {
        this.m_result = 1;
        this.setVisible(false);
    }

    private void performHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh146.htm");
    }
}

